/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.cells;

import appeng.api.config.IncludeExclude;
import appeng.api.storage.cells.ICellHandler;
import appeng.api.storage.cells.ISaveProvider;
import appeng.core.localization.GuiText;
import appeng.core.localization.Tooltips;
import appeng.me.cells.BasicCellInventory;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class BasicCellHandler
implements ICellHandler {
    public static final BasicCellHandler INSTANCE = new BasicCellHandler();

    @Override
    public boolean isCell(ItemStack is) {
        return BasicCellInventory.isCell(is);
    }

    @Override
    public BasicCellInventory getCellInventory(ItemStack is, ISaveProvider container) {
        return BasicCellInventory.createInventory(is, container);
    }

    public void addCellInformationToTooltip(ItemStack is, List<Component> lines) {
        BasicCellInventory handler = this.getCellInventory(is, null);
        if (handler == null) {
            return;
        }
        lines.add(Tooltips.bytesUsed(handler.getUsedBytes(), handler.getTotalBytes()));
        lines.add(Tooltips.typesUsed(handler.getStoredItemTypes(), handler.getTotalItemTypes()));
        if (handler.isPreformatted()) {
            MutableComponent list = (handler.getPartitionListMode() == IncludeExclude.WHITELIST ? GuiText.Included : GuiText.Excluded).text();
            if (handler.isFuzzy()) {
                lines.add((Component)GuiText.Partitioned.withSuffix(" - ").m_7220_((Component)list).m_130946_(" ").m_7220_((Component)GuiText.Fuzzy.text()));
            } else {
                lines.add((Component)GuiText.Partitioned.withSuffix(" - ").m_7220_((Component)list).m_130946_(" ").m_7220_((Component)GuiText.Precise.text()));
            }
        }
    }
}

